/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Entity.Projectiles;

import com.hoshino.cti.Entity.Projectiles.BaseFallenAmmo;
import com.hoshino.cti.Modifier.StarDragonHit;
import com.hoshino.cti.client.particle.ParticleType.StarFallParticleType;
import com.hoshino.cti.register.CtiEntity;
import com.hoshino.cti.register.CtiItem;
import com.hoshino.cti.register.CtiSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class StarDargonAmmo
extends BaseFallenAmmo {
    public StarDargonAmmo(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public StarDargonAmmo(LivingEntity owner, Level level, BlockPos targetPosition, float damageAmount, float killThreshold) {
        super((EntityType<? extends BaseFallenAmmo>)((EntityType)CtiEntity.star_dragon_ammo.get()), owner, level, targetPosition);
        this.setHurtDamage(damageAmount);
        this.setKillThreshold(killThreshold);
    }

    @Override
    protected void shockWaveHurt(Mob mob, Player player) {
        mob.m_6469_(DamageSource.m_19344_((Player)player).m_19380_().m_19382_(), this.getHurtDamage());
        Vec3 knock = mob.m_20182_().m_82546_(this.getVec3TargetPosition()).m_82541_().m_82490_(3.0);
        Vec3 finalKnock = new Vec3(knock.m_7096_(), 0.4, knock.m_7094_());
        mob.m_20256_(finalKnock);
        if (mob.m_21223_() < mob.m_21233_() * this.getKillThreshold() || this.getHurtDamage() > mob.m_21233_() * 10.0f) {
            mob.m_6667_(DamageSource.m_19344_((Player)player));
            mob.m_146870_();
            ModDataNBT data = ToolStack.from((ItemStack)player.m_21205_()).getPersistentData();
            int currentAmount = data.getInt(StarDragonHit.STAR_DUST);
            data.putInt(StarDragonHit.STAR_DUST, currentAmount + 1);
        }
    }

    @Override
    protected void onArrived(ServerPlayer player) {
        super.onArrived(player);
        this.directHurtLiving(DamageSource.m_19344_((Player)player).m_19380_().m_19382_().m_19381_(), this.getHurtDamage() * 10.0f, 5.0);
        if (!this.f_19853_.f_46443_) {
            StarFallParticleType particle = new StarFallParticleType(true, 1, 16318386, 1.0f, 1.0f, 10.0f, this.getVec3TargetPosition());
            player.m_9236_().m_8767_((ParticleOptions)particle, this.getVec3TargetPosition().m_7096_(), this.getVec3TargetPosition().m_7098_() + 0.05, this.getVec3TargetPosition().m_7094_(), 1, 0.0, 0.0, 0.0, 0.25);
            this.m_9236_().m_6269_(null, (Entity)player, CtiSounds.starHit.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        }
    }

    @Override
    @NotNull
    protected ParticleOptions getTailParticleType() {
        return ParticleTypes.f_123762_;
    }

    @NotNull
    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)CtiItem.star_dragon_ammo.get());
    }
}

